getwd()
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

## Packages
set.seed(717)
library(cubature)
library(lava) 
library(ggplot2)
library(mcGlobaloptim) 
library(DiceKriging) 
library(nloptr) 
library(MASS)
library(mcmc)
library(geoR)
library(RobustCalibration)
library(lhs)
library(RobustGaSP)
library(numDeriv)
library(ggplot2)
library(rTensor)
library(plotly)
library(R.matlab)
library(proxy)
library(abind)
library(scatterplot3d)
library(Matrix)
library(purrr)
library(plyr)
library(multiway)

# tempdir()
# dir.create(tempdir())
load("data4.RData")
load("c.pre.to.list.3.RData")

data.x <- data4$x0[2996:3360,]
data.y <- data4$y0[,,2996:3360]

dim.f = dim(data.y)[1:2]
d = ncol(data.x); lower.x = apply(data.x,2,min); upper.x = apply(data.x,2,max)

dim.s = c(2,2)
dim.h = prod(dim.s); dim.mode = length(dim.s)

N = nrow(data.x)
x0 = data.x; y0 = data.y

h <- function(y) sum(y)

ind.x.star = which.max(apply(y0,3,h))
h.star = apply(y0,3,h)[ind.x.star]
full.x.star = x0[ind.x.star,]

ind.x.star; h.star; full.x.star



################################################################################
#### GP ########################################################################
################################################################################
## Kernel
norm1 <- function(x1,x2) as.matrix(x1%*%t(x2))

ker.sele <- function(x1,x2,theta){
  x1 = matrix(x1,length(x1)/d,d); x2 = matrix(x2,length(x2)/d,d)
  n.s1 = nrow(x1); n.s2 = nrow(x2)
  theta1 = matrix(theta[3:(d+2)],n.s1,d,byrow=TRUE); theta2 = matrix(theta[3:(d+2)],n.s2,d,byrow=TRUE)
  R = theta[1]+theta[2]*norm1(x1-theta1,x2-theta2)
  return(R)
}

# norm0 <- function(x1,x2) as.matrix(x1%*%t(x2))
# norm1 <- function(x1,x2){
#   nor = list()
#   for(i in 1:d){
#     nor[[i]] = norm0(x1[,i],x2[,i])}
#   return(nor)
# } 
# 
# ker.sele <- function(x1,x2,theta){
#   x = norm1(x1,x2)
#   R0 = Map(function(x0,th) x0/th,x,theta)
#   R = Reduce("*", R0)
#   return(R)
# }

B.tuck.ml <- function(y,n){
  y0 = lapply(1:n, function(i) rTensor::as.tensor(y[,,i]))
  U.tuck = list()
  
  mode.unfold <- function(da,k) do.call(cbind, lapply(da, function(x) {k_unfold(x,k)@data}))
  for(i in 1:dim.mode) U.tuck[[i]] = svd(mode.unfold(y0, i))$u[, 1:dim.s[i]]
  core.ten = lapply(y0, function(x) ttl(x, lapply(U.tuck, t), 1:dim.mode))
  
  return(list(core.ten=core.ten, U.tuck=U.tuck))
}
# b.ren = B.tuck.ml(y,n)


################################################################################
## Our proposed method: NS-TOGP
## Kernel
vec.lab = list()
for(om.lab in 1:dim.mode){
  vec.lab[[om.lab]] = dim.s[om.lab]*(dim.s[om.lab]+1)/2
}
vec.lab[[dim.mode+1]] = d+2
vec.lab[[dim.mode+2]] = vec.lab[[dim.mode+3]] = 1
group.lab <- unlist(Map(rep, LETTERS[1:length(vec.lab)], unlist(vec.lab)))
dim.hyper.ml = length(group.lab)

lower.th = c(unlist(Map(rep, c(rep(1e-3,dim.mode),1e-3,1e-1,1e-10), unlist(vec.lab))))
upper.th = c(unlist(Map(rep, c(rep(1,dim.mode),10,10,1e-2), unlist(vec.lab))))

sig.ml <- function(t,ome){
  O = matrix(0,t,t)
  O[lower.tri(O, diag = TRUE)] <- ome
  return(O)
}

ker.ml <- function(y,n,the){
  the0 = split(the, group.lab)
  
  Omega = list()
  for(i in 1:dim.mode) Omega[[i]] = list(dim.s[i],the0[[i]])
  
  sig = lapply(Omega,function(the) sig.ml(the[[1]],the[[2]]))
  sig.re = Map(function(B) B%*%t(B), sig)
  return(Reduce(kronecker,sig.re))
}


likeli.ml <- function(x1,x2,y,n,the){
  the0 = split(the, group.lab)
  sig2 = the0[[dim.mode+2]]; tau2 = the0[[dim.mode+3]]
  
  omega = ker.ml(y,n,the)
  k.ini = kronecker(ker.sele(x1,x2,the0[[dim.mode+1]]),omega)
  
  k.y = sig2*k.ini+tau2*diag(n*dim.h)
  
  log.likeli = determinant(k.y,logarithm=TRUE)$modulus+t(c(y))%*%solve(k.y)%*%c(y)
  
  return(list(like=log.likeli, the0=the0))
}
# likeli.ml(x,x,y,n,s1,s2,c(runif(dim.hyper.mt)))


EIJ <- function(i,j,l){
  E0 = matrix(0,dim.s[l],dim.s[l]); E0[i,j] = 1
  return(E0)
}

der.l <- function(x1,x2,y,n,the){
  the0 = split(the, group.lab)
  
  ome = list()
  for(i in 1:dim.mode){ome[[i]] = the0[[i]]}
  th = the0[[dim.mode+1]]; sig2 = the0[[dim.mode+2]]; tau2 = the0[[dim.mode+3]]
  
  J <- function(i,l){
    E0 = matrix(0,dim.s[l],dim.s[l]); E0[i,i] = exp(sig.ml(dim.s[l],ome[[l]])[i,i])
    return(E0)
  }
  
  Omega = list()
  for(i in 1:dim.mode) Omega[[i]] = list(dim.s[i],the0[[i]])
  
  sig = lapply(Omega,function(the) sig.ml(the[[1]],the[[2]]))
  sig.re = Map(function(B) B%*%t(B), sig)
  omega = Reduce(kronecker,sig.re)
  
  k.ini = ker.sele(x1,x2,th)
  al.k1 = kronecker(k.ini,omega)
  
  k.y = sig2*al.k1+tau2*diag(n*dim.h)
  sol.k.y = solve(k.y)
  
  al.k = sol.k.y%*%c(y)
  der.l.sig2 = tr(sol.k.y%*%al.k1)-t(al.k)%*%al.k1%*%al.k
  der.l.tau2 = tr(sol.k.y)-t(al.k)%*%al.k
  
  der.th = array(jacobian(function(theta) ker.sele(x1,x2,theta), th),dim=c(n,n,d+2))
  der.l.th.i <- function(der) sig2*(tr(sol.k.y%*%kronecker(der,omega))-
                                      t(al.k)%*%kronecker(der,omega)%*%al.k)
  der.l.th = apply(der.th,3,der.l.th.i)
  
  der.l.phi = list()
  for(l in 1:dim.mode){
    der.l.phi[[l]] = matrix(0, dim.s[l], dim.s[l])
    
    der.l.phi.ij <- function(i,j) EIJ(i,j,l)%*%t(sig[[l]])+sig[[l]]%*%EIJ(j,i,l)
    it1 <- function(der.p){
      list1 = if (l > 1) sig.re[1:(l-1)] else 1
      list2 = if (l < dim.mode) sig.re[(l+1):dim.mode] else 1
      kro.list = list(sig2*k.ini,Reduce(kronecker,list1),der.p,Reduce(kronecker,list2))
      return(Reduce(kronecker,kro.list))
    } 
    it2 <- function(der.p) tr(sol.k.y%*%it1(der.p))-
      t(al.k)%*%it1(der.p)%*%al.k
    
    der.l.phi.1 = sapply(c(1:dim.s[l]), function(i) {
      sapply(c(1:i), function(j) it2(der.l.phi.ij(i, j)))
    })
    
    der.l.phi.ii <- function(i) J(i,l)%*%t(sig[[l]])+sig[[l]]%*%J(i,l)
    der.l.phi.dig = apply(as.matrix(c(1:dim.s[l])),1, function(i) it2(der.l.phi.ii(i)))
    
    for (i in 1:dim.s[l]) {
      der.l.phi[[l]][i, 1:i] <- der.l.phi.1[[i]]
    }
    # diag(der.l.phi[[l]]) = der.l.phi.dig   
  }
  
  result = list(der.l.phi=lapply(der.l.phi, function(mat) mat[lower.tri(mat, diag = TRUE)]), 
                der.l.th=der.l.th, der.l.sig2=der.l.sig2, der.l.tau2=der.l.tau2)
  return(result)
}


mlgp.hat <- function(x.new,x,y,n,n.test,hy){
  x.new = matrix(x.new,n.test,d)
  omega = ker.ml(y,n,unlist(hy))
  
  sig2 = hy[[dim.mode+2]]; tau2 = hy[[dim.mode+3]]
  
  k.ml.s0 = ker.sele(x,x,hy[[dim.mode+1]])
  k.ml.s = sig2*kronecker(k.ml.s0,omega)+tau2*diag(n*dim.h)
  
  k.ml.10 = ker.sele(x.new,x,hy[[dim.mode+1]])
  k.ml.1 = sig2*kronecker(k.ml.10,omega)
  
  k.ml.00 = ker.sele(x.new,x.new,hy[[dim.mode+1]])
  k.ml.0 = sig2*kronecker(k.ml.00,omega)
  
  k.oth = k.ml.1%*%solve(k.ml.s)
  
  f.hat.tuck = k.oth%*%c(y)
  var.hat.tuck = k.ml.0-k.oth%*%t(k.ml.1)
  
  result = list(mean.tuck = f.hat.tuck, cov.tuck = var.hat.tuck)
  return(result)
}
# mlgp.hat(x.star,x,y,n,1,split(runif(dim.hyper.ml), group.lab))



################################################################################
## Our proposed method: NS-mlGP-UCB
n = c.ini.set$n; m = c.ini.set$m; J.for = c.ini.set$J.for

like.re.ml = hyper.ml = fhat = lapply(1:J.for, function(x) list())
x0.ml = y0.ml = y0.tuck.ml = ind.x.ml = list()
mlgp.bo = h.ml = list()
regret.ml = ins.regret.ml = cum.regret.ml = list()
beta.ml = ucb.new.ml = lapply(1:J.for, function(x) list())


# j.for.ml = 1
for(j.for.ml in 1:J.for){
  
  ind.x = c.ini.set$ind.x.for[[j.for.to]]
  x = data.x[ind.x,]; y=y0[,,ind.x]
  
  y0.tuck = B.tuck.ml(y,n); B.tuck = Reduce(kronecker,y0.tuck$U.tuck)
  y0.0 = lapply(y0.tuck$core.ten, function(c) c@data)
  y.tuck = abind(y0.0, along = dim.mode+1)
  
  ## Setting
  ######################################## BO ####################################
  hyper.ml.old = directL(function(the) likeli.ml(x,x,y.tuck,n,the)$like,
                         lower.th,upper.th,control=list(maxeval=1000))$par
  hyper.ml.new = optim(par = hyper.ml.old,
                       fn = function(the) likeli.ml(x,x,y.tuck,n,the)$like,
                       gr = function(the) unlist(der.l(x,x,y.tuck,n,the)),
                       method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
  
  like.re.ml[[j.for.ml]][[1]] = likeli.ml(x,x,y.tuck,n,hyper.ml.new)
  hyper.ml[[j.for.ml]][[1]] = like.re.ml[[j.for.ml]][[1]]$the0
  
  x0 = data.x; inx0 = c(1:N)
  x0.ml[[j.for.ml]] = x; y0.ml[[j.for.ml]] = y; ind.x.ml[[j.for.ml]] = ind.x
  y0.tuck.ml[[j.for.ml]] = y.tuck; n.ml = n
  
  x.new.ml = t(as.matrix(x[which.max(apply(y,3,h)),]))
  y.new.ml = y[,,which.max(apply(y,3,h))]
  
  hyper.ml.ucb = unlist(hyper.ml[[j.for.ml]][[1]]); delta.ml = 0.05
  fhat[[j.for.ml]][[1]] = mlgp.hat(x.new.ml,x0.ml[[j.for.ml]],y0.tuck.ml[[j.for.ml]],
                                   n.ml,1,hyper.ml[[j.for.ml]][[1]])
  
  for(i.ml in 1:m){
    ind.x.new.ml = sample(inx0[-ind.x.ml[[j.for.ml]]],1) #which(apply(x0, 1, function(row) all(row == x0[-ind.x.ml[[j.for.ml]],][which.min(ucb.x),])))[1]
    x.new.ml = x0[ind.x.new.ml,]; y.new.ml = y0[,,ind.x.new.ml]
    y.tuck.new.ml = abind(ttl(rTensor::as.tensor(y.new.ml), 
                              lapply(y0.tuck$U.tuck,t), 1:dim.mode)@data, along=dim.mode+1)
    
    fhat[[j.for.ml]][[i.ml+1]] = mlgp.hat(x.new.ml,x0.ml[[j.for.ml]],y0.tuck.ml[[j.for.ml]],
                                          n.ml,n.test=1,hyper.ml[[j.for.ml]][[i.ml]])
    
    x0.ml[[j.for.ml]] = rbind(x0.ml[[j.for.ml]], x.new.ml)
    y0.ml[[j.for.ml]] = abind(y0.ml[[j.for.ml]], y.new.ml, along = dim.mode+1)
    y0.tuck.ml[[j.for.ml]] = abind(y0.tuck.ml[[j.for.ml]], y.tuck.new.ml, along = dim.mode+1)
    ind.x.ml[[j.for.ml]] = c(ind.x.ml[[j.for.ml]],ind.x.new.ml)
    n.ml = n+i.ml
    
    if(i.ml %% 150 == 0){
      hyper.ml.ucb = optim(par = unlist(hyper.ml[[j.for.ml]][[i.ml]]), 
                           fn = function(the) likeli.ml(x0.ml[[j.for.ml]],x0.ml[[j.for.ml]],y0.tuck.ml[[j.for.ml]],n.ml,the)$like, 
                           gr = function(the) unlist(der.l(x0.ml[[j.for.ml]],x0.ml[[j.for.ml]],y0.tuck.ml[[j.for.ml]],n.ml,the)), 
                           method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
    }else{
      hyper.ml.ucb = hyper.ml.ucb
    }
    
    like.re.ml[[j.for.ml]][[i.ml+1]] = likeli.ml(x0.ml[[j.for.ml]],x0.ml[[j.for.ml]],y0.tuck.ml[[j.for.ml]],n.ml,hyper.ml.ucb)
    hyper.ml[[j.for.ml]][[i.ml+1]] = like.re.ml[[j.for.ml]][[i.ml+1]]$the0
    print(i.ml)
  }
  mlgp.ucb <- function(x.new,ind.new) mlgp.hat(x.new,ind.new,x0.ml[[j.for.ml]],y0.tuck.ml[[j.for.ml]],
                                               n.ml,n.test=1,hyper.ml[[j.for.ml]][[i.ml+1]]) 
  mlgp.bo[[j.for.ml]] = mlgp.ucb
  
  h.ml[[j.for.ml]] = apply(y0.ml[[j.for.ml]],dim.mode+1,h)
  regret.ml[[j.for.ml]] = h.star-h.ml[[j.for.ml]]
  
  layout(matrix(1, nrow = 1, ncol = 1))
  plot(rep(h.star,(n.ml-n+1)),type="b",lwd=3,lty=1,pch=1,col=1,ylim=c(cummax(h.ml[[j.for.ml]])[n],h.star))
  lines(cummax(h.ml[[j.for.ml]])[n:n.ml],type="b",lwd=3,lty=2,pch=2,col=2)
  
  ins.regret.ml[[j.for.ml]] = h.star-cummax(h.ml[[j.for.ml]][(n+1):n.ml])
  cum.regret.ml[[j.for.ml]] = cumsum(ins.regret.ml[[j.for.ml]])
  
  plot(cumsum(ins.regret.ml[[j.for.ml]]),type="b",lwd=3,lty=2,pch=2,col=2)
  
  print(j.for.ml)
}

mat <- do.call(rbind, cum.regret.ml)
cum.regret.mean <- apply(mat,2, mean)
cum.regret.lower <- apply(mat,2, function(x) quantile(x, 0.025))
cum.regret.upper <- apply(mat,2, function(x) quantile(x, 0.975))


time <- 1:m
plot(time, cum.regret.mean, type = "l", lwd = 2, col = "blue", ylim = range(c(cum.regret.lower, cum.regret.upper)),
     ylab = "Value", xlab = "Time", main = "Mean with 95% Confidence Band")
polygon(c(time, rev(time)),c(cum.regret.upper, rev(cum.regret.lower)),
        col = rgb(0.1, 0.2, 0.9, 0.2), border = NA)
lines(time, cum.regret.mean, col = "blue", lwd = 2)


fml.rs.list = list(ind.x.star=ind.x.star, h.star=h.star, full.x.star=full.x.star,         
                    like.re.ml=like.re.ml, hyper.ml=hyper.ml, fhat=fhat,
                    x0.ml=x0.ml, y0.ml=y0.ml, mlgp.bo=mlgp.bo, ind.x.ml=ind.x.ml,  
                    h.ml=h.ml, regret.ml=regret.ml, ins.regret.ml=ins.regret.ml, cum.regret.ml=cum.regret.ml,
                    beta.ml=beta.ml, ucb.new.ml=ucb.new.ml)
save(fml.rs.list, file="c4.fml.rs.list.RData")



